
markup.push({

// -------------------------------------------------
// MARK: fir filter block

FIRFilterBlock:
{
	"+": "BlockTemplate",
	gxTitle: "FIR Filter",
	axTitle: "F I R Filter",
	geNodeClass: "GEFIRFilterNode",
	h4PresetsId: "FIRFilterPresets",
	gxPopoverInfo: "FIRFilterPopover",
	gxIconPainter: "ImagePainter.block.fir",
	gxLibraryIcon: "library.fir",
	gxLibraryDescription: "Finite Impulse Response Filter",
	geInitialUIState: { impulseExpanded: true },
},
	
// MARK: popover

FIRFilterPopover:
{
	"+": "PopoverTemplate",
	gxTitle: "FIR Filter",
	gxCanDrawSubviewsIntoLayer: true,
	gxLayout:
	[
		"H:|-12-[self(384)]-12-|",	// sets popover width
		"V:|-12-[self]-12-|",
		"V:|-41-[status]-0-[impulseBtn]-0-[impulse]-0-[advancedBtn]-0-[advanced]-8-[presetsGroup]",
				
		"H:|-0-[dropView]-0-|",
		"V:|-41-[dropView]-8-[presetsGroup]",
	],
	gxChildViews:
	{
		title: "PopoverTitle",
		switch: "PopoverOnOffSwitch",
		presetsGroup: presetsGroup(),
		dropView: {
			nsClass: "GXDropView",
			acceptDroppedAudioFiles: true,
			gxValueKey: "node.droppedAudioFile",
			gxLayerZPosition: 2,
			gxHilitePainter: {
				"+": "DropHilitePainter",
				gxCornerRadius: 0,
			},
		},
		status:
		{
			"+": "GroupView",
			gxLayout:
			[
				"H:|-0-[self]-0-|",

				"V:|-16-[gainSlider]-12-[delay]-16-|",

				"H:|-12-[gainLabel(82)]-7-[gainSlider]-0-[gainReadout(56)]-16-|&alignBaseline",
				"H:|-12-[delayLabel(82)]-8-[delay(140)]-0-[misrateWarning]-16-|&alignBaseline",
			],
			gxChildViews:
			{
				delayLabel: labelView("Actual Delay:"),
				delay : {
					"+": "LabelView.useMarkup.left.colorThemeLive2.size13",
					gxValueKey: "node.totalDelayString",
				},
				misrateWarning: {
					"+": "LabelView.right.size11",
					gxDefaultValue: "\u26A0\uFE0F Impulse resampled",
					gxShowOnKey: "node.showRateWarning",
				},
				gainLabel: labelView("Pre-Gain:"),
				gainSlider:
				{
					"+": "SliderView",
					gxValueKey: "node.preGain",
					gxDefaultValue: 0,
					gxRangeMin: -40,
					gxRangeMax: 0,
					axTitle: "Pre-Gain",
					axFormatter: "DBFormatter"
				},
				gainReadout:
				{
					"+": "ReadoutView.right",
					gxValueKey: "node.preGain",
					gxFormatter: "DBFormatter",
				},
			},
		},
		impulseBtn: {
			"+": "AdvancedGroupButton.noTopStroke",
			gxTitle: "<disclosure/> Impulse Response",
			gxValueKey: "uiState.impulseExpanded",
			axFormatter: disclosureAxFormatter("Impulse Response"),
		},
		impulse: {
			"+": "ExpandingGroupView.noTopStroke",
			gxValueKey: "uiState.impulseExpanded",
			gxCollapsible: true,
			gxCollapsedSize: 1,	// lets bottom stroke show
			gxExtraSize: 16,
			gxLayout:
			[
				"H:|-0-[self]-0-|",
				
				"V:|-10-[fileSelect]",
				"V:|-2-[fileName]-5-[description]-5-[length]-5-[groupDelay]-5-[idealGain]-8-[magPlot(90)]",

				"H:|-31-[fileSelect(102)]-16-[fileName]-12-|",
				"H:[fileSelect]-16-[description]-12-|",
				"H:[fileSelect]-16-[length]-12-|",
				"H:[fileSelect]-16-[groupDelay]-12-|",
				"H:[fileSelect]-16-[idealGain]-12-|",
				
				"V:|-2-[infoText(36)]",
				"H:[fileSelect]-16-[infoText]-12-|",

				"H:|-32-[magPlot]-16-|",
			],
			gxChildViews:
			{
				fileSelect: {
					"+": "ButtonView",
					gxValueKey: "node.importBtn",
					gxTitle: "Import File...",
					gxDisableOnKey: "running",
				},
				fileName: {
					"+": "LabelView.centerx",
					gxValueKey: "node.fileName",
					axIsIgnored: false,
					axHelp: "The original file name of the imported Impulse Response"
				},
				description: {
					"+": "LabelView.centerx",
					gxValueKey: "node.fileDescription",
					axIsIgnored: false,
					gxHideOnNilValue: true,
				},
				length: {
					"+": "LabelView.centerx",
					gxValueKey: "node.lengthString",
					axIsIgnored: false,
					gxHideOnNilValue: true,
				},
				groupDelay: {
					"+": "LabelView.centerx",
					gxValueKey: "node.groupDelayString",
					axIsIgnored: false,
					gxHideOnNilValue: true,
				},
				idealGain: {
					"+": "LabelView.centerx",
					gxValueKey: "node.idealPreGainString",
					axIsIgnored: false,
					gxHideOnNilValue: true,
				},
				infoText: {
					"+": "DescriptionLabelView.centerx",
					gxDefaultValue: "Select an audio file to use as \nthe Impulse Response.",
					gxShowOnKey: "node.showInfoText",
				},
				magPlot:
				{
					nsClass: "GXDrawView",
					gxValueKey: "node.magDisplayData",
					gxHideOnNilValue: true,
					gxBackPainter: {
						nsClass: "GXPainter",
						gxFrameColor: "BackColor3",
						gxStrokeWidth: 0.75,
					},
					gxForePainter: {
						nsClass: "GXSparklinePainter",
						gxStrokeColor: "ForeColor2",
						gxRangeMin: -1,
						gxRangeMax: 16,
						gxStrokeWidth: 2.5,
					}
				},
			},
		},
		advancedBtn: {
			"+": "AdvancedGroupButton.noTopStroke",
			gxTitle: "<disclosure/> Advanced",
			gxValueKey: "uiState.advancedExpanded",
			axFormatter: disclosureAxFormatter("Advanced"),
		},
		advanced: {
			"+": "ExpandingGroupView.noTopStroke",
			gxValueKey: "uiState.advancedExpanded",
			gxCollapsible: true,
			gxCollapsedSize: 1,	// lets bottom stroke show
			gxExtraSize: 18,
			gxLayout: [
					   "H:|-0-[self]-0-|",
					   
					   "V:|-8-[math64bit]-10-[misrate]-10-[infoText(30)]", //-8-[threadLimit]-8-[misrate]",

					   "H:|-29-[math64bit]-18-|&alignBaseline",
//					   "H:|-8-[threadLimitLabel(80)]-8-[threadLimit]-24-|&alignBaseline",

					   "H:|-30-[misrateLabel(84)]-4-[misrate]-24-|&alignBaseline",
					   "H:|-31-[infoIcon(16)]-8-[infoText]-24-|",
					   "V:[misrate]-13-[infoIcon]",

			],
			gxChildViews: {
				math64bit: {
					"+": "CheckboxTemplate",
					gxTitle: "<checkbox/> Higher Precision, Slower Processing <foreColor2>(64-Bit Math)",
					gxValueKey: "node.math64bitProcessing",
					gxDisableOnKey: "running"
				},
	//			threadLimitLabel: labelView("Threads:"),
	//			threadLimit : {
	//				"+": "PopupMenuTemplate.useMarkup",
	//				gxValueKey: "node.threadLimitProcessing",
	//				axTitle: "Threads",
	//				axHelp: "The number of multiprocessing threads used when running",
	//				gxDisableOnKey: "running",
	//				gxMenuItems:
	//				[
	//					menuItem("1", 1),
	//					menuItem("2 <italic><foreColor2>(Default)", 2),
	//					menuItem("3", 3),
	//				],
	//			},
				misrateLabel: labelView("Re-sampling:", "left"),
				misrate : {
					"+": "PopupMenuTemplate",
					gxValueKey: "node.mismatchHandlingMode",
					gxMenuItemsKeyPath: "node.rateMismatchMenuItems",
					axTitle: "Re-sampling method",
					gxDisableOnKey: "running",
				},
				infoIcon: { "+": "InfoIcon" },
				infoText: {
					"+": "DescriptionLabelView",
					gxDefaultValue: "The Impulse Response is resampled when it differs from the session’s sample rate."
				},
			},
		},
	},
},

	
})

